import { PrismaClient } from '@prisma/client'
import bcrypt from 'bcryptjs'

const prisma = new PrismaClient()

async function main() {
    console.log('🌱 Seeding database...')

    // Hash passwords
    const hashedPassword = await bcrypt.hash('jabnet2026', 10)
    const hashedSuperAdminPassword = await bcrypt.hash('Galon@123', 10)

    // Create Super Admin
    const superAdmin = await prisma.user.upsert({
        where: { email: 'admin@jabnet.id' },
        update: {},
        create: {
            nama: 'Super Admin',
            email: 'admin@jabnet.id',
            password: hashedSuperAdminPassword,
            role: 'super_admin',
            noWa: '6280000000000',
            targetPsbMonthly: 0,
            targetVisitDaily: 0,
        },
    })
    console.log('✅ Super Admin created')

    // Create Users
    const ilham = await prisma.user.upsert({
        where: { email: 'ilham@jabnet.id' },
        update: {},
        create: {
            nama: 'Ilham (Chief Ops)',
            email: 'ilham@jabnet.id',
            password: hashedPassword,
            role: 'admin',
            noWa: '6281234567890',
            targetPsbMonthly: 50,
            targetVisitDaily: 0,
        },
    })

    const mikhail = await prisma.user.upsert({
        where: { email: 'mikhail@jabnet.id' },
        update: {},
        create: {
            nama: 'Mikhail Yazid B.',
            email: 'mikhail@jabnet.id',
            password: hashedPassword,
            role: 'spv_marketing',
            noWa: '6281234567891',
            targetPsbMonthly: 50,
            targetVisitDaily: 0,
        },
    })

    const yadi = await prisma.user.upsert({
        where: { email: 'yadi@jabnet.id' },
        update: {},
        create: {
            nama: 'Yadi Nur A.',
            email: 'yadi@jabnet.id',
            password: hashedPassword,
            role: 'sales_senior',
            noWa: '6281234567892',
            targetPsbMonthly: 18,
            targetVisitDaily: 10,
        },
    })

    const rizky = await prisma.user.upsert({
        where: { email: 'rizky@jabnet.id' },
        update: {},
        create: {
            nama: 'Rizky Nurzaman',
            email: 'rizky@jabnet.id',
            password: hashedPassword,
            role: 'sales_senior',
            noWa: '6281234567893',
            targetPsbMonthly: 18,
            targetVisitDaily: 10,
        },
    })

    const herdi = await prisma.user.upsert({
        where: { email: 'herdi@jabnet.id' },
        update: {},
        create: {
            nama: 'Herdiansyah',
            email: 'herdi@jabnet.id',
            password: hashedPassword,
            role: 'sales_senior',
            noWa: '6281234567894',
            targetPsbMonthly: 18,
            targetVisitDaily: 10,
        },
    })

    const raisya = await prisma.user.upsert({
        where: { email: 'raisya@jabnet.id' },
        update: {},
        create: {
            nama: 'Raisya Amelia',
            email: 'raisya@jabnet.id',
            password: hashedPassword,
            role: 'sales_junior',
            noWa: '6281234567895',
            targetPsbMonthly: 8,
            targetVisitDaily: 10,
        },
    })

    console.log('✅ Users created')

    // Create Master Paket
    const pakets = [
        { namaPaket: 'To The Moon', speed: '20 Mbps', harga: 189000, segmenTarget: 'Retail' },
        { namaPaket: 'Galaksi', speed: '30 Mbps', harga: 219000, segmenTarget: 'Retail' },
        { namaPaket: 'Nebula', speed: '50 Mbps', harga: 279000, segmenTarget: 'Retail / UMKM' },
        { namaPaket: 'Supernova', speed: '100 Mbps', harga: 399000, segmenTarget: 'UMKM / Corporate' },
        { namaPaket: 'Custom Corporate', speed: 'Dedicated', harga: 0, segmenTarget: 'Corporate' },
        { namaPaket: 'Mitra Package', speed: 'Wholesale', harga: 0, segmenTarget: 'Mitra/Reseller' },
    ]

    for (const paket of pakets) {
        await prisma.masterPaket.create({ data: paket })
    }
    console.log('✅ Master Paket created')

    // Create Sales Areas
    const areaAssignments = [
        { salesId: yadi.id, kecamatan: 'Karangpawitan', quarter: 'Q1-2026', targetPsb: 9 },
        { salesId: yadi.id, kecamatan: 'Cilawu', quarter: 'Q1-2026', targetPsb: 9 },
        { salesId: rizky.id, kecamatan: 'Tarogong Kidul', quarter: 'Q1-2026', targetPsb: 9 },
        { salesId: rizky.id, kecamatan: 'Banyuresmi', quarter: 'Q1-2026', targetPsb: 9 },
        { salesId: herdi.id, kecamatan: 'Garut Kota', quarter: 'Q1-2026', targetPsb: 18 },
        { salesId: raisya.id, kecamatan: 'Tarogong Kaler', quarter: 'Q1-2026', targetPsb: 8 },
    ]

    for (const area of areaAssignments) {
        await prisma.salesArea.create({ data: area })
    }
    console.log('✅ Sales Areas created')

    // Create Sample Leads
    const sampleLeads = [
        {
            namaLengkap: 'Budi Santoso',
            noWa: '6281234000001',
            alamat: 'Jl. Merdeka No. 15, RT 03/RW 05',
            kelurahan: 'Kota Kulon',
            kecamatan: 'Garut Kota',
            segmen: 'retail',
            sumberLead: 'canvassing',
            paketInterest: 'To The Moon',
            pipelineStage: 'contacted',
            priority: 'warm',
            estimatedValue: 189000,
            assignedSalesId: herdi.id,
            createdById: herdi.id,
            nextFollowupDate: '2026-02-13',
        },
        {
            namaLengkap: 'Siti Nurhaliza',
            noWa: '6281234000002',
            alamat: 'Jl. Ahmad Yani No. 88',
            kelurahan: 'Sukagalih',
            kecamatan: 'Tarogong Kidul',
            segmen: 'retail',
            sumberLead: 'referral',
            paketInterest: 'Galaksi',
            pipelineStage: 'visited',
            priority: 'hot',
            estimatedValue: 219000,
            assignedSalesId: rizky.id,
            createdById: rizky.id,
            nextFollowupDate: '2026-02-13',
        },
        {
            namaLengkap: 'CV Maju Jaya',
            noWa: '6281234000003',
            alamat: 'Jl. Raya Samarang No. 42',
            kelurahan: 'Samarang',
            kecamatan: 'Samarang',
            segmen: 'umkm',
            sumberLead: 'sosmed',
            paketInterest: 'Nebula',
            pipelineStage: 'negotiation',
            priority: 'hot',
            estimatedValue: 279000,
            assignedSalesId: yadi.id,
            createdById: yadi.id,
            nextFollowupDate: '2026-02-12',
        },
        {
            namaLengkap: 'Ahmad Hidayat',
            noWa: '6281234000004',
            alamat: 'Kp. Sindangsari RT 01/RW 02',
            kelurahan: 'Sindangsari',
            kecamatan: 'Karangpawitan',
            segmen: 'retail',
            sumberLead: 'sosialisasi_rt_rw',
            paketInterest: 'To The Moon',
            pipelineStage: 'new_lead',
            priority: 'cold',
            estimatedValue: 189000,
            assignedSalesId: yadi.id,
            createdById: yadi.id,
        },
        {
            namaLengkap: 'Dewi Rahayu',
            noWa: '6281234000005',
            alamat: 'Jl. Pembangunan No. 7',
            kelurahan: 'Jayaraga',
            kecamatan: 'Tarogong Kidul',
            segmen: 'retail',
            sumberLead: 'wa_incoming',
            paketInterest: 'Galaksi',
            pipelineStage: 'surveyed',
            priority: 'warm',
            estimatedValue: 219000,
            assignedSalesId: rizky.id,
            createdById: rizky.id,
            nextFollowupDate: '2026-02-14',
        },
        {
            namaLengkap: 'PT Mandiri Sejahtera',
            noWa: '6281234000006',
            alamat: 'Jl. Ciledug No. 100',
            kelurahan: 'Ciledug',
            kecamatan: 'Garut Kota',
            segmen: 'corporate',
            sumberLead: 'telepon',
            paketInterest: 'Supernova',
            pipelineStage: 'won',
            priority: 'hot',
            estimatedValue: 399000,
            assignedSalesId: herdi.id,
            createdById: herdi.id,
        },
        {
            namaLengkap: 'Rina Marlina',
            noWa: '6281234000007',
            alamat: 'Jl. Raya Cilawu No. 23',
            kelurahan: 'Cilawu',
            kecamatan: 'Cilawu',
            segmen: 'retail',
            sumberLead: 'canvassing',
            paketInterest: 'To The Moon',
            pipelineStage: 'lost',
            priority: 'cold',
            estimatedValue: 189000,
            lostReason: 'kompetitor',
            lostNotes: 'Sudah langganan provider lain, kontrak 1 tahun',
            assignedSalesId: yadi.id,
            createdById: yadi.id,
        },
        {
            namaLengkap: 'Asep Sunandar',
            noWa: '6281234000008',
            alamat: 'Kp. Cibunar RT 05/RW 03',
            kelurahan: 'Cibunar',
            kecamatan: 'Tarogong Kaler',
            segmen: 'retail',
            sumberLead: 'canvassing',
            paketInterest: 'To The Moon',
            pipelineStage: 'contacted',
            priority: 'warm',
            estimatedValue: 189000,
            assignedSalesId: raisya.id,
            createdById: raisya.id,
            nextFollowupDate: '2026-02-15',
        },
        {
            namaLengkap: 'Warung Bu Imas',
            noWa: '6281234000009',
            alamat: 'Jl. Otista No. 55',
            kelurahan: 'Kota Wetan',
            kecamatan: 'Garut Kota',
            segmen: 'umkm',
            sumberLead: 'canvassing',
            paketInterest: 'Nebula',
            pipelineStage: 'new_lead',
            priority: 'cold',
            estimatedValue: 279000,
            assignedSalesId: herdi.id,
            createdById: herdi.id,
        },
        {
            namaLengkap: 'Deden Koswara',
            noWa: '6281234000010',
            alamat: 'Kp. Pasirwangi RT 02/RW 01',
            kelurahan: 'Pasirwangi',
            kecamatan: 'Banyuresmi',
            segmen: 'retail',
            sumberLead: 'referral',
            paketInterest: 'Galaksi',
            pipelineStage: 'visited',
            priority: 'warm',
            estimatedValue: 219000,
            assignedSalesId: rizky.id,
            createdById: rizky.id,
            nextFollowupDate: '2026-02-13',
        },
    ]

    for (const lead of sampleLeads) {
        const createdLead = await prisma.lead.create({ data: lead })

        // Add sample activity for non-new leads
        if (lead.pipelineStage !== 'new_lead') {
            await prisma.leadActivity.create({
                data: {
                    leadId: createdLead.id,
                    activityType: lead.pipelineStage === 'visited' ? 'visit' : lead.pipelineStage === 'contacted' ? 'phone_call' : 'follow_up',
                    result: lead.pipelineStage === 'won' ? 'closed_won' : lead.pipelineStage === 'lost' ? 'closed_lost' : 'interested',
                    notes: `Aktivitas ${lead.pipelineStage} untuk ${lead.namaLengkap}`,
                    salesId: lead.assignedSalesId,
                    visitLatitude: lead.pipelineStage === 'visited' ? -7.2167 + Math.random() * 0.05 : null,
                    visitLongitude: lead.pipelineStage === 'visited' ? 107.9 + Math.random() * 0.05 : null,
                },
            })
        }
    }
    console.log('✅ Sample Leads & Activities created')

    console.log('🎉 Seed completed!')
}

main()
    .catch((e) => {
        console.error(e)
        process.exit(1)
    })
    .finally(async () => {
        await prisma.$disconnect()
    })
