'use client'

import Sidebar from '@/components/Sidebar'
import { ToastProvider } from '@/components/Toast'
import { useState, useEffect } from 'react'

export default function AppLayout({
    children,
}: {
    children: React.ReactNode
}) {
    const [sidebarCollapsed, setSidebarCollapsed] = useState(false)
    const [mounted, setMounted] = useState(false)

    useEffect(() => {
        setMounted(true)
        // Sync with sidebar collapsed state
        const stored = localStorage.getItem('sidebar-collapsed')
        if (stored === 'true') setSidebarCollapsed(true)

        const handler = (e: Event) => {
            const detail = (e as CustomEvent).detail
            setSidebarCollapsed(detail.collapsed)
        }
        window.addEventListener('sidebar-toggle', handler)
        return () => window.removeEventListener('sidebar-toggle', handler)
    }, [])

    if (!mounted) return null

    return (
        <ToastProvider>
            <div className="min-h-screen" style={{ background: 'var(--color-bg)' }}>
                <Sidebar />
                <main className={`main-content ${sidebarCollapsed ? 'sidebar-collapsed' : ''}`} style={{ minHeight: '100dvh' }}>
                    <div className="p-4 md:p-6 pt-[72px] md:pt-6 max-w-[1200px] mx-auto">
                        {children}
                    </div>
                </main>
            </div>
        </ToastProvider>
    )
}
