import type { Metadata } from "next";
import "./globals.css";

export const metadata: Metadata = {
  title: "JABNET Sales CRM",
  description: "Lead Management & Sales Pipeline Monitoring System - PT Jujur Amanah Barokah",
  manifest: "/manifest.json",
  themeColor: "#1A2744",
  viewport: "width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no",
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="id">
      <body>
        {children}
      </body>
    </html>
  );
}
