'use client'

import { useEffect, useState } from 'react'

export default function AnimatedPage({ children, className = '', style }: { children: React.ReactNode; className?: string; style?: React.CSSProperties }) {
    const [visible, setVisible] = useState(false)

    useEffect(() => {
        // Trigger animation after mount
        const raf = requestAnimationFrame(() => setVisible(true))
        return () => cancelAnimationFrame(raf)
    }, [])

    return (
        <div
            className={className}
            style={{
                opacity: visible ? 1 : 0,
                transform: visible ? 'translateY(0)' : 'translateY(12px)',
                transition: 'opacity 0.4s ease-out, transform 0.4s ease-out',
                ...style,
            }}
        >
            {children}
        </div>
    )
}

export function StaggeredItem({ children, index = 0, className = '' }: { children: React.ReactNode; index?: number; className?: string }) {
    const [visible, setVisible] = useState(false)

    useEffect(() => {
        const timer = setTimeout(() => setVisible(true), 60 * index)
        return () => clearTimeout(timer)
    }, [index])

    return (
        <div
            className={className}
            style={{
                opacity: visible ? 1 : 0,
                transform: visible ? 'translateY(0) scale(1)' : 'translateY(8px) scale(0.98)',
                transition: 'opacity 0.35s ease-out, transform 0.35s ease-out',
            }}
        >
            {children}
        </div>
    )
}
