'use client'

import { useEffect, useState } from 'react'
import Link from 'next/link'

interface EmptyStateProps {
    icon: React.ReactNode
    title: string
    description: string
    actionLabel?: string
    actionHref?: string
    onAction?: () => void
}

export default function EmptyState({ icon, title, description, actionLabel, actionHref, onAction }: EmptyStateProps) {
    const [visible, setVisible] = useState(false)

    useEffect(() => {
        const raf = requestAnimationFrame(() => setVisible(true))
        return () => cancelAnimationFrame(raf)
    }, [])

    return (
        <div
            style={{
                display: 'flex', flexDirection: 'column', alignItems: 'center', justifyContent: 'center',
                padding: '4rem 2rem', textAlign: 'center',
                opacity: visible ? 1 : 0,
                transform: visible ? 'translateY(0) scale(1)' : 'translateY(16px) scale(0.95)',
                transition: 'all 0.5s cubic-bezier(0.22, 1, 0.36, 1)',
            }}
        >
            <div style={{
                width: 72, height: 72, borderRadius: '50%',
                background: 'var(--color-subtle, #f8fafc)',
                display: 'flex', alignItems: 'center', justifyContent: 'center',
                marginBottom: '1.5rem',
                color: 'var(--color-muted, #94a3b8)',
            }}>
                {icon}
            </div>
            <h3 style={{ fontSize: '1.125rem', fontWeight: 700, color: 'var(--color-text)', marginBottom: '0.5rem' }}>{title}</h3>
            <p style={{ fontSize: '0.875rem', color: 'var(--color-muted)', maxWidth: 360, lineHeight: 1.6 }}>{description}</p>
            {actionLabel && (
                actionHref ? (
                    <Link href={actionHref} className="btn-accent" style={{ marginTop: '1.5rem' }}>
                        {actionLabel}
                    </Link>
                ) : (
                    <button onClick={onAction} className="btn-accent" style={{ marginTop: '1.5rem' }}>
                        {actionLabel}
                    </button>
                )
            )}
        </div>
    )
}
