'use client'

import { useEffect, useState, useRef } from 'react'

export function useCountUp(target: number, duration: number = 1200, delay: number = 0): number {
    const [count, setCount] = useState(0)
    const startTime = useRef<number | null>(null)
    const rafId = useRef<number>(0)

    useEffect(() => {
        if (target === 0) {
            setCount(0)
            return
        }

        const delayTimer = setTimeout(() => {
            const animate = (timestamp: number) => {
                if (!startTime.current) startTime.current = timestamp
                const progress = Math.min((timestamp - startTime.current) / duration, 1)

                // Ease-out cubic
                const eased = 1 - Math.pow(1 - progress, 3)
                setCount(Math.round(eased * target))

                if (progress < 1) {
                    rafId.current = requestAnimationFrame(animate)
                }
            }

            rafId.current = requestAnimationFrame(animate)
        }, delay)

        return () => {
            clearTimeout(delayTimer)
            cancelAnimationFrame(rafId.current)
        }
    }, [target, duration, delay])

    return count
}
