import { clsx, type ClassValue } from "clsx"
import { twMerge } from "tailwind-merge"

export function cn(...inputs: ClassValue[]) {
    return twMerge(clsx(inputs))
}

export const PIPELINE_STAGES = [
    { value: 'new_lead', label: 'New Lead', color: '#6366f1' },
    { value: 'contacted', label: 'Contacted', color: '#8b5cf6' },
    { value: 'visited', label: 'Visited', color: '#3b82f6' },
    { value: 'surveyed', label: 'Surveyed', color: '#06b6d4' },
    { value: 'negotiation', label: 'Negotiation', color: '#f59e0b' },
    { value: 'won', label: 'Won', color: '#10b981' },
    { value: 'lost', label: 'Lost', color: '#ef4444' },
] as const

export const PRIORITY_OPTIONS = [
    { value: 'cold', label: 'Cold', color: '#3b82f6', bg: '#eff6ff' },
    { value: 'warm', label: 'Warm', color: '#f59e0b', bg: '#fffbeb' },
    { value: 'hot', label: 'Hot', color: '#ef4444', bg: '#fef2f2' },
] as const

export const SEGMEN_OPTIONS = [
    { value: 'retail', label: 'Retail' },
    { value: 'umkm', label: 'UMKM' },
    { value: 'corporate', label: 'Corporate' },
    { value: 'mitra', label: 'Mitra' },
] as const

export const SUMBER_LEAD_OPTIONS = [
    { value: 'canvassing', label: 'Canvassing' },
    { value: 'referral', label: 'Referral' },
    { value: 'sosmed', label: 'Social Media' },
    { value: 'sosialisasi_rt_rw', label: 'Sosialisasi RT/RW' },
    { value: 'wa_incoming', label: 'WA Incoming' },
    { value: 'telepon', label: 'Telepon' },
    { value: 'website', label: 'Website' },
    { value: 'kompetitor_switch', label: 'Kompetitor Switch' },
] as const

export const ACTIVITY_TYPES = [
    { value: 'visit', label: 'Visit', icon: 'MapPin' },
    { value: 'phone_call', label: 'Phone Call', icon: 'Phone' },
    { value: 'wa_chat', label: 'WA Chat', icon: 'MessageCircle' },
    { value: 'survey_lokasi', label: 'Survey Lokasi', icon: 'Search' },
    { value: 'presentasi', label: 'Presentasi', icon: 'Presentation' },
    { value: 'negosiasi', label: 'Negosiasi', icon: 'Handshake' },
    { value: 'registrasi_psb', label: 'Registrasi PSB', icon: 'FileCheck' },
    { value: 'follow_up', label: 'Follow Up', icon: 'RefreshCw' },
] as const

export const ACTIVITY_RESULTS = [
    { value: 'interested', label: 'Tertarik', color: '#10b981' },
    { value: 'not_interested', label: 'Belum Tertarik', color: '#ef4444' },
    { value: 'callback', label: 'Callback', color: '#f59e0b' },
    { value: 'need_survey', label: 'Perlu Survey', color: '#3b82f6' },
    { value: 'closed_won', label: 'Closed Won', color: '#10b981' },
    { value: 'closed_lost', label: 'Closed Lost', color: '#ef4444' },
    { value: 'no_answer', label: 'Tidak Jawab', color: '#6b7280' },
] as const

export const LOST_REASONS = [
    { value: 'harga', label: 'Harga' },
    { value: 'coverage', label: 'Coverage' },
    { value: 'kompetitor', label: 'Kompetitor' },
    { value: 'tidak_jadi', label: 'Tidak Jadi' },
    { value: 'pindah', label: 'Pindah' },
    { value: 'lainnya', label: 'Lainnya' },
] as const

export const KECAMATAN_GARUT = {
    priority1: ['Garut Kota', 'Tarogong Kidul', 'Tarogong Kaler', 'Karangpawitan'],
    priority2: ['Cilawu', 'Banyuresmi', 'Samarang', 'Bayongbong'],
    priority3: ['Leles', 'Kadungora', 'Cibatu', 'Wanaraja'],
}

export const ALL_KECAMATAN = [
    ...KECAMATAN_GARUT.priority1,
    ...KECAMATAN_GARUT.priority2,
    ...KECAMATAN_GARUT.priority3,
]

export function formatCurrency(amount: number): string {
    return new Intl.NumberFormat('id-ID', {
        style: 'currency',
        currency: 'IDR',
        minimumFractionDigits: 0,
        maximumFractionDigits: 0,
    }).format(amount)
}

export function formatDate(date: string | Date): string {
    return new Intl.DateTimeFormat('id-ID', {
        day: '2-digit',
        month: 'short',
        year: 'numeric',
    }).format(new Date(date))
}

export function formatDateTime(date: string | Date): string {
    return new Intl.DateTimeFormat('id-ID', {
        day: '2-digit',
        month: 'short',
        year: 'numeric',
        hour: '2-digit',
        minute: '2-digit',
    }).format(new Date(date))
}

export function getStageLabel(stage: string): string {
    return PIPELINE_STAGES.find(s => s.value === stage)?.label ?? stage
}

export function getStageColor(stage: string): string {
    return PIPELINE_STAGES.find(s => s.value === stage)?.color ?? '#6b7280'
}

export function getPriorityInfo(priority: string) {
    return PRIORITY_OPTIONS.find(p => p.value === priority) ?? PRIORITY_OPTIONS[0]
}
